package jamezo97.clonecraft.gui;

import jamezo97.clonecraft.entity.EntityModifiable;
import jamezo97.clonecraft.entity.clone.EntityAttackEntry;
import jamezo97.clonecraft.entity.clone.EntityClone;
import jamezo97.clonecraft.network.Handler13UpdateEntity;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Map.Entry;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.CCEntityAnything;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.IAnimals;
import net.minecraft.world.World;

public class GuiChooseAttackEntities extends GuiScreen {

	EntityClone clone;
	
	GuiScreen parent = null;
	
	GuiChooseAttackSlot slot;
	
	double rotX = 0.0, rotY = 0.0d, rotZ = 0.0;

	public static ArrayList<EntityAttackEntry> allEntities = new ArrayList<EntityAttackEntry>();
	
	public Minecraft getMc(){
		return mc;
	}
	
	public GuiChooseAttackEntities(EntityClone clone, GuiScreen parent){
		this.clone = clone;
		this.parent = parent;
	}

	@Override
	public void initGui() {
		slot = new GuiChooseAttackSlot(this);
		slot.registerScrollButtons(0, 1);
		buttonList.add(new GuiButton(2, width/2 - 205, 5, 200, 20, "Select All"));
		buttonList.add(new GuiButton(3, width/2 + 5, 5, 200, 20, "Un Select All"));
		buttonList.add(new GuiButton(4, width/2 - 205, height-60, 200, 20, "Select All Mobs"));
		buttonList.add(new GuiButton(5, width/2 + 5, height-60, 200, 20, "Select All Animals"));
		buttonList.add(new GuiButton(6, (width-150)/2, height-30, 150, 20, "Back"));
		
		
	}
	
	
	
	

	@Override
	protected void actionPerformed(GuiButton gb) {
		boolean entitiesModified = false;
		if(gb.id == 2){
			for(int a = 0; a < allEntities.size(); a++){
				if(clone.options.addEntityToAttack(allEntities.get(a))){
					entitiesModified = true;
				}
			}
			updateAllToServer();
		}else if(gb.id == 3){
			clone.options.clearEntitiesToAttack();
			entitiesModified = true;
		}else if(gb.id == 4){
			for(int a = 0; a < allEntities.size(); a++){
				Class c = allEntities.get(a).theClass;
				if(hasInterface(c, IMob.class)){
					if(clone.options.addEntityToAttack(allEntities.get(a))){
						entitiesModified = true;
					}
				}
			}
		}else if(gb.id == 5){
			for(int a = 0; a < allEntities.size(); a++){
				Class c = allEntities.get(a).theClass;
				if(hasInterface(c, IAnimals.class)){
					if(clone.options.addEntityToAttack(allEntities.get(a))){
						entitiesModified = true;
					}
				}
			}
		}else if(gb.id == 6){
			mc.displayGuiScreen(parent);
		}
		if(entitiesModified){
			updateAllToServer();
		}
	}
	
	
	private void updateAllToServer() {
		new Handler13UpdateEntity(clone.entityId, true, true, clone.options.getAllEntities()).sendToServer();
	}

	boolean dir = true;
	
	float radians = 0;
	
	@Override
	public void updateScreen() {
		rotY += 2;
		if(rotY > 360){
			rotY = rotY % 360;
		}
		
		radians += 0.1f;
		if(radians > Math.PI * 2){
			radians = (float)(radians % (Math.PI * 2));
		}
		rotX = (Math.cos(radians))*30.0;
		/*if(dir){
			rotX += 1;
			if(rotX > 30){
				dir = false;
			}
		}else{
			rotX -= 1;
			if(rotX < -30){
				dir = true;
			}
		}*/
	}

	public boolean hasInterface(Class theClass, Class theInterface){
		Class superClass = theClass;
		do{
			Class<?>[] interfaces = superClass.getInterfaces();
			for(int a = 0; a < interfaces.length; a++){
				if(interfaces[a] == theInterface){
					return true;
				}
			}
			superClass = superClass.getSuperclass();
		}while(superClass != null);
		
		return false;
	}

	@Override
	public void drawScreen(int par1, int par2, float par3) {
		slot.drawScreen(par1, par2, par3);
		super.drawScreen(par1, par2, par3);
	}

	@Override
	protected void keyTyped(char par1, int par2) {
		if(par2 == 1){
			mc.displayGuiScreen(parent);
		}else{
			super.keyTyped(par1, par2);
		}
	}
	
	static{
		loadAllEntities();
	}

	private static void loadAllEntities() {
		Map map = EntityList.IDtoClassMapping;
		if(map != null){
			Iterator it = map.entrySet().iterator();
			while(it.hasNext()){
				Entry entry = (Entry)it.next();
				int entityId = (Integer)entry.getKey();
				Class entityClass = (Class)entry.getValue();
				String name = EntityList.getStringFromID(entityId);
				if(entityClass != null && name != null){
					if(EntityLiving.class.isAssignableFrom(entityClass)){
						if(!(entityClass == EntityLiving.class || entityClass == CCEntityAnything.class || entityClass == EntityModifiable.class || entityClass == EntityDragon.class || entityClass == EntityClone.class || entityClass == EntityMob.class)){
							try{
								Constructor c = entityClass.getConstructor(World.class);
								if(c != null){
									allEntities.add(new EntityAttackEntry(name, entityClass, entityId));
								}
							}catch(Exception e){}
						}
					}
				}
			}
		}
	}

	public void onRemove(EntityAttackEntry entry) {
		new Handler13UpdateEntity(clone.entityId, false, false, entry.entityId).sendToServer();
	}
	
	public void onAdd(EntityAttackEntry entry) {
		new Handler13UpdateEntity(clone.entityId, true, false, entry.entityId).sendToServer();
	}

	@Override
	public boolean doesGuiPauseGame() {
		return false;
	}
	
	
	
	
	
}
